;C prototype: void DrawSprite32_SHADOW (short x, short y, short h, void *sprite, void *dest);
;
;void DrawSprite32_SHADOW (register short x asm("%d0"),
;		     register short y asm("%d1"),
;		     register short h asm("%d2"),
;		     register void *sprite asm("%a1"),
;		     register void *dest asm("%a0"));

	xdef	_DrawSprite32_SHADOW

_DrawSprite32_SHADOW:
    dbf      d2,__suite__
    rts

__suite__:
    move.l   d3,-(a7)
    move.l   d5,-(a7)
    move.w   d4,-(a7)
    move.w   d6,-(a7)
    
    ;addq.l   #4,a0
    
    ;y*15 
    move.w    d1,d3
    lsl.w     #4,d1
    sub.w     d3,d1
    
    ;x/16
    move.w    d0,d3
    lsr.w     #4,d3
    
    add.w     d3,d1
    add.w     d1,d1
    adda.l    d1,a0
    	
    andi.w   #15,d0          ; d0=rightshift
    moveq.l  #16,d1
    sub.w    d0,d1          ; d1=lefshift
    
    ;Mask1
    moveq.l  #-1,d5
    lsr.l    d0,d5
    not.l    d5
    
    ;Mask2
    move.w   #-1,d6
    lsl.w    d1,d6
    not.w    d6

    lsr.w    #1,d2
    bcs.s    Bouboucle32

    lea.l    -30(a0),a0
    bra.s    Milieu

Bouboucle32:   
    ;lightplane
    move.l   (a0),d3
    move.w   4(a0),d4
    not.l    d3
    not.w    d4
    or.l     6000(a0),d3
    or.w     6000+4(a0),d4
    move.w   d4,-(a7)
    move.l   d3,-(a7)
    
    ;darkplane
    move.l   6000(a0),d3
    move.w   6000+4(a0),d4
    or.l     (a0),d3
    or.w     4(a0),d4
    move.w   d4,-(a7)
    move.l   d3,-(a7)
        
    ; masque
    move.l   (a1)+,d3
    move.w   d3,d4
    lsr.l    d0,d3
    lsl.w    d1,d4
    or.l     d5,d3
    or.w     d6,d4
    and.l    d3,(a0)
    and.w    d4,4(a0)
    and.l    d3,6000(a0)
    and.w    d4,6000+4(a0)
    not.l    d3
    not.w    d4
    and.l    d3,(a7)
    and.l    d3,4+2(a7)
    and.w    d4,4(a7)
    and.w    d4,4+2+4(a7)
    
    ; zone d'ombres
    move.l   (a7)+,d3
    move.w   (a7)+,d4
    or.l     d3,6000(a0)
    or.w     d4,6000+4(a0)
    move.l   (a7)+,d3
    move.w   (a7)+,d4
    or.l     d3,(a0)
    or.w     d4,4(a0)

    move.l   (a1)+,d3
    move.l   (a1)+,d3 
    
Milieu:
    ;lightplane
    move.l   30(a0),d3
    move.w   30+4(a0),d4
    not.l    d3
    not.w    d4
    or.l     6000+30(a0),d3
    or.w     6000+30+4(a0),d4
    move.w   d4,-(a7)
    move.l   d3,-(a7)
    
    ;darkplane
    move.l   6000+30(a0),d3
    move.w   6000+30+4(a0),d4
    or.l     30(a0),d3
    or.w     30+4(a0),d4
    move.w   d4,-(a7)
    move.l   d3,-(a7)
        
    ; masque
    move.l   (a1)+,d3
    move.w   d3,d4
    lsr.l    d0,d3
    lsl.w    d1,d4
    or.l     d5,d3
    or.w     d6,d4
    and.l    d3,30(a0)
    and.w    d4,30+4(a0)
    and.l    d3,6000+30(a0)
    and.w    d4,6000+30+4(a0)
    not.l    d3
    not.w    d4
    and.l    d3,(a7)
    and.l    d3,4+2(a7)
    and.w    d4,4(a7)
    and.w    d4,4+2+4(a7)
    
    ; zone d'ombres
    move.l   (a7)+,d3
    move.w   (a7)+,d4
    or.l     d3,6000+30(a0)
    or.w     d4,6000+30+4(a0)
    move.l   (a7)+,d3
    move.w   (a7)+,d4
    or.l     d3,30(a0)
    or.w     d4,30+4(a0)
    
    move.l   (a1)+,d3
    move.l   (a1)+,d3 

    lea.l    30+30(a0),a0

    dbf    d2,Bouboucle32
    
    move.w   (a7)+,d6
    move.w   (a7)+,d4
    move.l   (a7)+,d5
    move.l   (a7)+,d3
    rts


